(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8469,        253]*)
(*NotebookOutlinePosition[      9313,        280]*)
(*  CellTagsIndexPosition[      9269,        276]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ Example\ 4.2  .2\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ To\ compute\ v_j\ , \ take\ h = 1/n, \ 
      with\ n = \(2. \ Then\ s0 = 0\), \[IndentingNewLine]s1 = 0.5, \ 
      s2 = \(1.0 . \ Also\ take\ x = 
          0 \((0.1)\) 1.0\)\ *) \[IndentingNewLine]\(h = 
        1/5;\)\), "\[IndentingNewLine]", 
    \(v0 = h^2/6; \ v1 = h^2; \ v2 = h^2; \ v3 = h^2; v4 = h^2; \ 
    v5 = 2\ h^2;\), "\[IndentingNewLine]", 
    \(\(k[x_, s_] := If[x \[LessEqual] s, x, s];\)\), "\[IndentingNewLine]", 
    \(y0 + v0*y0*k[0, 0] + v1*y1*k[0, 0.2] + v2*y2*k[0, 0.4] + 
      v3*y3*k[0, 0.6] + v4*y4*k[0, 0.8] + y5*v5*k[0, 1. ]\)}], "Input"],

Cell[BoxData[
    \(y0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y0 + v0*y0*k[0.2, 0] + v1*y1*k[0.2, 0.2] + v2*y2*k[0.2, 0.4] + 
      v3*y3*k[0.2, 0.6] + v4*y4*k[0.2, 0.8] + y5*v5*k[0.2, 1. ]\)], "Input"],

Cell[BoxData[
    \(y0 + 0.008`\ y1 + 0.008`\ y2 + 0.008`\ y3 + 0.008`\ y4 + 
      0.016`\ y5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y0 + v0*y0*k[0.4, 0] + v1*y1*k[0.4, 0.2] + v2*y2*k[0.4, 0.4] + 
      v3*y3*k[0.4, 0.6] + v4*y4*k[0.4, 0.8] + y5*v5*k[0.4, 1. ]\)], "Input"],

Cell[BoxData[
    \(y0 + 0.008`\ y1 + 0.016`\ y2 + 0.016`\ y3 + 0.016`\ y4 + 
      0.032`\ y5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y0 + v0*y0*k[0.6, 0] + v1*y1*k[0.6, 0.2] + v2*y2*k[0.6, 0.4] + 
      v3*y3*k[0.6, 0.6] + v4*y4*k[0.6, 0.8] + y5*v5*k[0.6, 1. ]\)], "Input"],

Cell[BoxData[
    \(y0 + 0.008`\ y1 + 0.016`\ y2 + 0.024`\ y3 + 0.024`\ y4 + 
      0.048`\ y5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y0 + v0*y0*k[0.8, 0] + v1*y1*k[0.8, 0.2] + v2*y2*k[0.8, 0.4] + 
      v3*y3*k[0.8, 0.6] + v4*y4*k[0.8, 0.8] + y5*v5*k[0.8, 1. ]\)], "Input"],

Cell[BoxData[
    \(y0 + 0.008`\ y1 + 0.016`\ y2 + 0.024`\ y3 + 0.032`\ y4 + 
      0.064`\ y5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y0 + v0*y0*k[1, 0] + v1*y1*k[1, 0.2] + v2*y2*k[1, 0.4] + 
      v3*y3*k[1, 0.6] + v4*y4*k[1, 0.8] + y5*v5*k[1. , 1. ]\)], "Input"],

Cell[BoxData[
    \(y0 + 0.008`\ y1 + 0.016`\ y2 + 0.024`\ y3 + 0.032`\ y4 + 
      0.08`\ y5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(rightside[x_] := 1.  + Exp[1. ]*x;\)\), "\[IndentingNewLine]", 
    \(r = Table[rightside[x], {x, 0, 1. , 0.2}]\)}], "Input"],

Cell[BoxData[
    \({1.`, 1.5436563656918092`, 2.0873127313836184`, 2.630969097075427`, 
      3.1746254627672363`, 3.718281828459045`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{y0 == 
          1, \[IndentingNewLine]y0 + 0.008`\ y1 + 0.008`\ y2 + 0.008`\ y3 + 
            0.008`\ y4 + 0.016`\ y5 == 
          1.5436563656918092`, \[IndentingNewLine]y0 + 0.008`\ y1 + 
            0.016`\ y2 + 0.016`\ y3 + 0.016`\ y4 + 0.032`\ y5 == 
          2.0873127313836184`, \[IndentingNewLine]y0 + 0.008`\ y1 + 
            0.016`\ y2 + 0.024`\ y3 + 0.024`\ y4 + 0.048`\ y5 == 
          2.630969097075427`, \[IndentingNewLine]y0 + 0.008`\ y1 + 
            0.016`\ y2 + 0.024`\ y3 + 0.032`\ y4 + 0.064`\ y5 == 
          3.1746254627672363`, \[IndentingNewLine]y0 + 0.008`\ y1 + 
            0.016`\ y2 + 0.024`\ y3 + 0.032`\ y4 + 0.08`\ y5 == 
          3.718281828459045`}, {y0, y1, y2, y3, y4, y5}]\)], "Input"],

Cell[BoxData[
    \({{y0 \[Rule] 1.`, y1 \[Rule] 0.`, y2 \[Rule] 5.551115123125783`*^-14, 
        y3 \[Rule] \(-5.551115123125783`*^-14\), 
        y4 \[Rule] 5.551115123125783`*^-14, 
        y5 \[Rule] 33.97852285573805`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*Exact\ values\ *) \[IndentingNewLine]\(exact[x_] := 
        Exp[x];\)\), "\[IndentingNewLine]", 
    \(Table[exact[x], {x, 0. , 1. , 0.2}]\)}], "Input"],

Cell[BoxData[
    \({1.`, 1.2214027581601699`, 1.4918246976412703`, 1.822118800390509`, 
      2.225540928492468`, 2.718281828459045`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(k[x_, s_] := If[x \[LessEqual] s, x, s];\)\), "\[IndentingNewLine]", 
    \(\(x = {0, \ 0.2, \ 0.4, \ 0.6, \ 0.8, 
          1. };\)\), "\[IndentingNewLine]", 
    \(\(s = {0, \ 0.2, \ 0.4, \ 0.6, \ 0.8, 
          1. };\)\), "\[IndentingNewLine]", 
    \(matk = Table[k[x[\([i]\)], s[\([j]\)]], \ {i, 6}, {j, 6}]\)}], "Input"],

Cell[BoxData[
    \({{0, 0, 0, 0, 0, 0}, {0, 0.2`, 0.2`, 0.2`, 0.2`, 0.2`}, {0, 0.2`, 0.4`, 
        0.4`, 0.4`, 0.4`}, {0, 0.2`, 0.4`, 0.6`, 0.6`, 0.6`}, {0, 0.2`, 0.4`, 
        0.6`, 0.8`, 0.8`}, {0, 0.2`, 0.4`, 0.6`, 0.8`, 1.`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d = {{1/150, 0, 0, 0, 0, 0}, \[IndentingNewLine]{0, 1/25, \ 0, 0, 0, 
          0}, \[IndentingNewLine]\ {0, 0, \ 1/25, 0, 0, 
          0}, \[IndentingNewLine]{0, 0, \ 0, 1/25, 0, 
          0}, \[IndentingNewLine]{0, 0, \ 0, 0, 1/25, 
          0}, \[IndentingNewLine]{0, 0, \ 0, 0, 0, 2/25}}\)], "Input"],

Cell[BoxData[
    \({{1\/150, 0, 0, 0, 0, 0}, {0, 1\/25, 0, 0, 0, 0}, {0, 0, 1\/25, 0, 0, 
        0}, {0, 0, 0, 1\/25, 0, 0}, {0, 0, 0, 0, 1\/25, 0}, {0, 0, 0, 0, 0, 
        2\/25}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a = matk\  . d\)], "Input"],

Cell[BoxData[
    \({{0.`, 0.`, 0.`, 0.`, 0.`, 0.`}, {0.`, 0.008`, 0.008`, 0.008`, 0.008`, 
        0.016`}, {0.`, 0.008`, 0.016`, 0.016`, 0.016`, 0.032`}, {0.`, 0.008`, 
        0.016`, 0.024`, 0.024`, 0.048`}, {0.`, 0.008`, 0.016`, 0.024`, 
        0.032`, 0.064`}, {0.`, 0.008`, 0.016`, 0.024`, 0.032`, 
        0.08`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b = IdentityMatrix[6] - a\)], "Input"],

Cell[BoxData[
    \({{1.`, 0.`, 0.`, 0.`, 0.`, 0.`}, {0.`, 
        0.992`, \(-0.008`\), \(-0.008`\), \(-0.008`\), \(-0.016`\)}, {0.`, \
\(-0.008`\), 
        0.984`, \(-0.016`\), \(-0.016`\), \(-0.032`\)}, {0.`, \(-0.008`\), \
\(-0.016`\), 
        0.976`, \(-0.024`\), \(-0.048`\)}, {0.`, \(-0.008`\), \(-0.016`\), \
\(-0.024`\), 
        0.968`, \(-0.064`\)}, {0.`, \(-0.008`\), \(-0.016`\), \(-0.024`\), \
\(-0.032`\), 0.92`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(r = {1.`, 1.5436563656918092`, 2.0873127313836184`, 2.630969097075427`, 
        3.1746254627672363`, 3.718281828459045`}\)], "Input"],

Cell[BoxData[
    \({1.`, 1.5436563656918092`, 2.0873127313836184`, 2.630969097075427`, 
      3.1746254627672363`, 3.718281828459045`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[b, r]\)], "Input"],

Cell[BoxData[
    \({1.`, 1.6991798993541194`, 2.3847663595134057`, 3.051274688796585`, 
      3.693372820569391`, 4.305923969777642`}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{Automatic, 74}, {Automatic, 13}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 59, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[1801, 54, 599, 10, 139, "Input"],
Cell[2403, 66, 36, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2476, 72, 160, 2, 59, "Input"],
Cell[2639, 76, 108, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2784, 83, 160, 2, 59, "Input"],
Cell[2947, 87, 108, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3092, 94, 160, 2, 59, "Input"],
Cell[3255, 98, 108, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3400, 105, 160, 2, 59, "Input"],
Cell[3563, 109, 108, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3708, 116, 150, 2, 43, "Input"],
Cell[3861, 120, 107, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4005, 127, 148, 2, 43, "Input"],
Cell[4156, 131, 149, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4342, 138, 758, 12, 203, "Input"],
Cell[5103, 152, 239, 4, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5379, 161, 177, 3, 59, "Input"],
Cell[5559, 166, 148, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5744, 173, 350, 6, 75, "Input"],
Cell[6097, 181, 246, 3, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6380, 189, 327, 5, 107, "Input"],
Cell[6710, 196, 197, 3, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6944, 204, 47, 1, 27, "Input"],
Cell[6994, 207, 336, 5, 101, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7367, 217, 58, 1, 27, "Input"],
Cell[7428, 220, 444, 9, 101, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7909, 234, 154, 2, 59, "Input"],
Cell[8066, 238, 149, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8252, 245, 50, 1, 27, "Input"],
Cell[8305, 248, 148, 2, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

